/**
 *  List reducing with rFold. A list reducing closure is one
 *    that is applied to a binary closure, a base value and a
 *    list. If the list is empty then the base value is returned.
 *    Otherwise, the binary closure is applied to the first item
 *    in the list and the recursive call to the list reducer.
 *
 *  The closure rFold is defined in the Functor class for this
 *    purpose.
 */

import fp.*

	//  Closure sum adds the items in a list
def sum = Functor.rFold.curry(Functor.bAdd, 0)

println "sum: ${sum([11, 12, 13, 14])}"



def append = { list1, list2 ->
    def result = []
    result.addAll(list1)
    result.addAll(list2)
    
    return result
}

	//  Closure flat flattens a list of lists
def flat = Functor.rFold.curry(append, [])

println "flat: ${flat([[11, 12, 13], [21, 22, 23, 24], [31, 32]])}"
