/**
 *  A simple GUI demonstrating a simple menu. The menu items
 *    simply echo a message on to the console.
 */

import groovy.swing.SwingBuilder
import javax.swing.*

	//  Create a builder
def sB = new SwingBuilder()


	//  Now the frame
def frame = sB.frame(title : 'Example01', location : [100, 100], size : [400, 300], defaultCloseOperation : WindowConstants.EXIT_ON_CLOSE) {
    menuBar {
        menu(text : 'File', mnemonic : 'F') {
            menuItem() {
                action(name : 'New',		mnemonic : 'N',	closure : { println 'File + New' })
            }
            menuItem() {
                action(name : 'Open...',	mnemonic : 'O',	closure : { println 'File + Open...' })
            }
            separator()
            menuItem() {
                action(name : 'Save',		mnemonic : 'S',	closure : { println 'File + Save' })
            }
            menuItem() {
                action(name : 'Save as...',	mnemonic : 'A',	closure : { println 'File + Save as...' })
            }
            separator()
            menuItem() {
                action(name : 'Exit',		mnemonic : 'X',	closure : { System.exit(0) })
            }
        }
        menu(text : 'Help', mnemonic : 'H') {
            menuItem() {
                action(name : 'About',		mnemonic : 'A',	closure : { println 'Help + About' })
            }
        }
    }
}

	//  Now show it
frame.pack()
frame.setVisible(true)
