import java.util.regex.*


def regex = ~'cheese'



	// partial find
assert 'cheesecake' =~ 'cheese'
assert !('cheesecake' =~ 'fromage')
assert 'cheesecake' =~ regex



	// total match
assert !('cheesecake' ==~ 'cheese')



	// positional matches
def rhyme = 'Humpty Dumpty sat on a wall'
assert rhyme =~ '^Humpty'
assert rhyme =~ 'wall$'



	// quantifiers
assert 'aaaaab' =~ 'a*b'
assert 'b' =~ 'a*b'
assert 'aaacd' =~ 'a*c?d'
assert 'aaad' =~ 'a*c?d'
assert 'aaaaab' =~ 'a{5}b'
assert !('aab' =~ 'a{5}b')



	// wildcard matches
assert rhyme =~ '.all'
assert '3.14' =~ '3.14'
assert '3X14' =~ '3.14'
assert '3.14' =~ '3\\.14'
assert !('3X14' =~ '3\\.14')

assert '3.14' =~ '3\\.[0-9]{2}'



	// character classes
assert rhyme =~ '[HD]umpty'
assert !(rhyme =~ '[hd]umpty')
assert !(rhyme =~ '[^HD]umpty')




	// groups
assert 'ababab' ==~ '(ab)*'
assert !('ababa' ==~ '(ab)*')
assert 'ababc' ==~ '(ab)*c'
assert 'aaac' ==~ '(a|b)*c'
assert 'bbbc' ==~ '(a|b)*c'
assert 'ababc' ==~ '(a|b)*c'



matcher = 'ababc' =~ '(ab)*c'
matcher.matches()
println "groupCount: ${matcher.groupCount()}"
println "matcher.group(0): ${matcher.group(0)}"
println "matcher.group(1): ${matcher.group(1)}"
println "matcher[0]: ${matcher[0]}"
println "matcher[0][1]: ${matcher[0][1]}"



matcher = 'ababc' =~ /(ab)*c/
matcher.matches()
println "groupCount: ${matcher.groupCount()}"
println "matcher.group(0): ${matcher.group(0)}"
println "matcher.group(1): ${matcher.group(1)}"
println "matcher[0]: ${matcher[0]}"
println "matcher[0][1]: ${matcher[0][1]}"
