/**
 *  A library comprises a stock of books. Associated with each book
 *  title there is a list of the names of each borrower. If the list
 *  is empty then the book is not on loan to any borrower.
 *  
 *  Using a text-based menu, a user should be able to:
 *
 *	add and remove books from the loan stock;
 *	record the loan and return of a book;
 *	display details of the current loan stock;
 *	display the number of books on loan to a given borrower and
 *	display the number of borrowers of a book. 
 *
 */

import console.*

def addBook(library, bookTitle) {
    library[bookTitle]= []
}

def removeBook(library, bookTitle) {  
    library.remove(bookTitle)      
}

def lendBook(library, bookTitle, borrowerName) {
    library[bookTitle] << borrowerName       
}

def returnBook(library, bookTitle, borrowerName) {
    library[bookTitle].remove(borrowerName)
}

def writeLoanStock(library) {
    println "\nLibrary stock: ${library} \n"
}

def readNumberBorrowedBooks(library, borrowerName) {
    def borrowerNames = library.values().asList()
    borrowerNames = borrowerNames.flatten()
    return borrowerNames.count(borrowerName)
}

def readNumberBorrowers(library, bookTitle) {
    return library[bookTitle].size()
}

def readBookTitle(){
    print('\tEnter book title: ')
    return Console.readLine()
}

def readBorrowerName(){
    print('\tEnter borrower name: ')
    return  Console.readLine()
}

def readMenuSelection(){
    println()
    println('0: Quit')
    println("1: Add new book")
    println('2: Remove book')
    println('3: Lend a book')
    println('4: Return a book')
    println('5: Display loan stock')
    println('6: Display number of books on loan to a borrower')
    println('7: Display number of borrowers of a book')
       
    print('\n\tEnter choice: ')    
    return Console.readLine()
} 


def library = [ 'Groovy' : ['Ken', 'John'],'OOD' : ['Ken'],'Java' : ['John', 'Sally'],
               'UML' : ['Sally'],'Basic' : [] ]
    
def choice = readMenuSelection()

while(choice != '0'){
    
    if(choice == '1'){      
        addBook(library, readBookTitle())
    }
    else if(choice == '2'){
        removeBook(library, readBookTitle())   
    }
    else if(choice == '3'){
        lendBook(library, readBookTitle(), readBorrowerName())
    }
    else if(choice == '4'){
        returnBook(library, readBookTitle(), readBorrowerName())
    }
    else if(choice == '5'){
        writeLoanStock(library)
    }
    else if(choice == '6'){
        def count = readNumberBorrowedBooks(library, readBorrowerName())
        println "\nNumber of books borrowed: ${count}\n"
    }
    else if(choice == '7'){
        def count = readNumberBorrowers(library, readBookTitle())
        println "\nNumber of borrowers: ${count}\n"
    }
    else {
        println('\nUnknown selection\n')
    }
      // next selection
    choice = readMenuSelection()
}
println('\nSystem closing\n')  