/**
 *  A bank account represented by two properties for the account
 *    number and the account balance. The class includes a redefined
 *    toString method and we create a list of Account objects.
 */

class Account {
    def number			// account number
    def balance			// current balance
    
    def credit(amount) {
        balance += amount
    }
    
    def debit(amount) {			// only if there are sufficient funds
        if(balance >= amount)
            balance -= amount
    }
    
    String toString() {			// redefinition
        return "Account: ${number} with balance: ${balance}"
    }
    
}

	//  populate a list with the instances
def accounts = [new Account(number : 'ABC123', balance : 1200),
            new Account(number : 'PQR456', balance : 200),
            new Account(number : 'XYZ789', balance : 123)]

	//  now display each
accounts.each { acc ->
    println acc			// automatically call toString
}
