/**
 *  A bank account class with a constructor method. The parameterised
 *    constructor uses its parameter values to initialize the property
 *    values. The object instances are then created using positional
 *    parameters.
 */

class Account {
    
    def Account(number, balance) {	// constructor method
        this.number = number
        this.balance = balance
    }
    
    def credit(amount) {
        balance += amount
    }
    
    def debit(amount) {			// only if there are sufficient funds
        if(balance >= amount)
            balance -= amount
    }
    
    String toString() {			// redefinition
        return "Account: ${number} with balance: ${balance}"
    }
    
    def number			// account number
    def balance			// current balance
}

	//  populate a list with the instances
def accounts = [new Account('ABC123', 1200),
            new Account('PQR456', 200),
            new Account('XYZ789', 123)]

	//  now display each
accounts.each { acc ->
    println acc				// automatically call toString
}

//def acc = new Account(number : 'ABC123', balance : 1200)	// No matching constructor