/**
 *  A bank account represented by two properties for the account
 *    number and the account balance. The class includes a toString
 *    method and we create a list of Account objects.
 */

class Account {
    
    def credit(amount) {
        balance += amount
    }
    
    def debit(amount) {		// only if there are sufficient funds
        if(balance >= amount)
            balance -= amount
    }
    
    String toString() {		// redefinition
        return "Account: ${number} with balance: ${balance}"
    }
    
// ---------- properties ----------------------------------

    def number			// account number
    def balance			// current balance
    
}

class Bank {
    
    def openAccount(number, balance) {
        def acc = new Account(number : number, balance : balance)
        accounts[number] = acc
    }
    
    def creditAccount(number, amount) {
        def acc = this.findAccount(number)
        if(acc != null)
            acc.credit(amount)
    }
    
    def debitAccount(number, amount) {
        def acc = this.findAccount(number)
        if(acc != null)
            acc.debit(amount)
    }
    
    def getAccountBalance(number) {
        def acc = this.findAccount(number)
        return (acc == null) ? null : acc.balance
    }
    
    def getTotalAssets() {
        def total = 0
        accounts.each { number, account -> total += account.balance }
        return total
    }
    
    def findAccount(number) {
        def acc = accounts.find { entry -> entry.key == number }
        return (acc == null) ? null : acc.value
    }
    
// ---------- properties ----------------------------------
    
    def name			// name of bank
    def accounts = [ : ]	// accounts opened with the bank

}

	//  open new bank
def bk = new Bank(name : 'Community')

	//  Open new accounts
bk.openAccount('ABC123', 1200)
bk.openAccount('DEF456', 1000)
bk.openAccount('GHI789', 2000)

	//  Perform transactions on a particular account
bk.creditAccount('ABC123', 200)		// balance now 1400
bk.debitAccount('ABC123', 900)		// balance now 500
bk.debitAccount('ABC123', 700)		// balance remains unchanged at 500

	//  Display details of this account
println "Balance for account ABC123 is: ${bk.getAccountBalance('ABC123')}"

	//  Calculate total bank assets
println "Total assets: ${bk.getTotalAssets()}"
