/**
 *  A Library populated with Book objects. We can add a new Book
 *    to the Library, and we can obtain a listing of the stock.
 *    Additionally, we can register new borrowers and lend/return
 *    books to/from borrowers.
 */

class Book {
    
    def attachBorrower(borrower) {
        this.borrower = borrower
    }
    
    def detachBorrower() {
        borrower = null
    }
    
    String toString() {		// redefinition
        return "Book: ${catalogNumber}: ${title} by: ${author}"
    }
    
// ---------- properties ----------------------------------

    def catalogNumber
    def title
    def author
    def borrower = null
    
}


class Borrower {
    
    def attachBook(bk) {
        borrowedBooks[bk.catalogNumber] = bk
        bk.attachBorrower(this)
    }
    
    def detachBook(bk) {
        borrowedBooks.remove(bk.catalogNumber)
        bk.detachBorrower()
    }
    
    String toString() {
        return "Borrower: ${membershipNumber}; ${name}"
    }
    
// ---------- properties ----------------------------------

    def membershipNumber
    def name
    def borrowedBooks = [ : ]
}


class Library {
        
    def addBook(bk) {
        loanStock[bk.catalogNumber] = bk
    }
    
    def displayStock() {
        println "\n\nLibrary: ${name}"
        println '================'
        
        loanStock.each { catalogNumber, book -> println "    ${book}" }
    }
    
    def displayBooksAvailableForLoan() {
        println "\n\nLibrary: ${name} : Available for loan"
        println '================'
        
        loanStock.each { catalogNumber, book -> if(book.borrower == null) println "    ${book}" }
    }
    
    def displayBooksOnLoan() {
        println "\n\nLibrary: ${name} : On loan"
        println '================'
        
        loanStock.each { catalogNumber, book -> if(book.borrower != null) println "    ${book}" }
    }

    def registerBorrower(borrower) {
        borrowers[borrower.membershipNumber] = borrower
    }
    
    def displayBorrowers() {
        println "\n\nLibrary: ${name} : Borrower details"
        println '================'
        
        borrowers.each { membershipNumber, borrower ->
            println borrower            
            borrower.borrowedBooks.each { catalogNumber, book -> println "    ${book}" }
        }
    }

    def lendBook(catalogNumber, membershipNumber) {
        def loanStockEntry = loanStock.find { entry -> entry.key == catalogNumber }
        def borrowersEntry = borrowers.find { entry  -> entry.key == membershipNumber }
        borrowersEntry.value.attachBook(loanStockEntry.value)
    }
    
    def returnBook(catalogNumber) {
        def loanStockEntry = loanStock.find { entry -> entry.key == catalogNumber }
        def bor = loanStockEntry.value.borrower
        bor.detachBook(loanStockEntry.value)
    }

// ---------- properties ----------------------------------

    def name
    def loanStock = [ : ]
    def borrowers = [ : ]
}



	//  Create a library object
def lib = new Library(name : 'Dunning')

	//  Create some books...
def bk1 = new Book(catalogNumber : '111', title : 'Groovy', author : 'Ken')
def bk2 = new Book(catalogNumber : '222', title : 'OOD', author : 'Ken')
def bk3 = new Book(catalogNumber : '333', title : 'UML', author : 'John')

	//  ...add then to the loan stock
lib.addBook(bk1)
lib.addBook(bk2)
lib.addBook(bk3)

	//  See stock
lib.displayStock()

	//  Now introduce some borrowers
bo1 = new Borrower(membershipNumber : '1234', name : 'Jessie')
bo2 = new Borrower(membershipNumber : '5678', name : 'Sally')

lib.registerBorrower(bo1)
lib.registerBorrower(bo2)

	//  See borrowers
lib.displayBorrowers()

	//  Finally, make some transactions
lib.displayBooksAvailableForLoan()

lib.lendBook('111', '1234')

lib.displayBooksAvailableForLoan()
lib.displayBooksOnLoan()
lib.displayBorrowers()

lib.returnBook('111')

lib.displayBooksAvailableForLoan()
lib.displayBooksOnLoan()
lib.displayBorrowers()
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                