import textio.*



class Action {

    def addPublication() {
        print('Add a book (B) or journal (J)? ')
        def pubType = ConsoleIO.in.readString()
        
        if(pubType == 'B' || pubType == 'b') {
            print('Enter book catalog number: ')
            def inputCatalogNumber = ConsoleIO.in.readLine()
            print('Enter book title: ')
            def inputTitle = ConsoleIO.in.readLine()
            print('Enter book author: ')
            def inputAuthor = ConsoleIO.in.readLine()
            
            def bk = new Book(catalogNumber : inputCatalogNumber, title : inputTitle, author : inputAuthor)
            
            if(library.getPublication(inputCatalogNumber) == null) {
                library.addPublication(bk)
            } else {
                println '\nCannot add: Book already present\n'
            }
        
        } else if(pubType == 'J' || pubType == 'j') {
            print('Enter journal catalog number: ')
            def inputCatalogNumber = ConsoleIO.in.readLine()
            print('Enter journal title: ')
            def inputTitle = ConsoleIO.in.readLine()
            print('Enter journal editor: ')
            def inputEditor = ConsoleIO.in.readLine()
            
            def jo = new Journal(catalogNumber : inputCatalogNumber, title : inputTitle, editor : inputEditor)
            
            if(library.getPublication(inputCatalogNumber) == null) {
                library.addPublication(jo)
            } else {
                println '\nCannot add: Journal already present\n'
            }

        } else
            println('Incorrect response')
    }
    
    def displayStock() {
        println "\nLibrary: ${library.name}"
        println '================'
        
        library.loanStock.each { entry -> println "    ${entry.value}" }        
    }
    
    def displayPublicationsAvailableForLoan() {
        println "\nLibrary: ${library.name}"
        println '================'
        println 'Available for loan'
        
        library.loanStock.each { entry -> if(entry.value.borrower == null) println "    ${entry.value}" }
    }
    
    def displayPublicationsOnLoan() {
        println "\nLibrary: ${library.name}"
        println '================'
        println 'On loan'
      
        library.loanStock.each { entry -> if(entry.value.borrower != null) println "    ${entry.value}" }
    }
    
    def registerBorrower() {
        print('Enter borrower membership number: ')
        def membershipNumber = ConsoleIO.in.readLine()
        print('Enter borrower name: ')
        def name = ConsoleIO.in.readLine()
        
        def bor = new Borrower(membershipNumber : membershipNumber, name : name)
        
        library.registerBorrower(bor)
    }
    
    def displayBorrowers() {
        println "\nLibrary: ${library.name}"
        println '================'
        
        library.borrowers.each { borrowerKey, borrowerValue ->
            println borrowerValue

            def publications = borrowerValue.borrowedPublications
            publications.each { publicationKey, publicationValue -> println "   ${publicationValue}" }
        }      
    }
    
    def lendPublication() {
        print('Enter publication catalog number: ')
        def inputCatalogNumber = ConsoleIO.in.readLine()
        print('Enter borrower membership number: ')
        def inputMembershipNumber = ConsoleIO.in.readLine()
        
        library.lendPublication(inputCatalogNumber, inputMembershipNumber)
    }
    
    def returnPublication() {
        print('Enter publication catalog number: ')
        def inputCatalogNumber = ConsoleIO.in.readLine()
        
        library.returnPublication(inputCatalogNumber)
    }
    
// ---------- properties ----------------------------------

    @Property library

}
