import console.*

class Action {

    def setLibrary(library) {
        this.library = library
    }
    
    def addBook() {
        print('\nEnter book catalog number: ')
        def catalogNumber = Console.readLine()
        print('Enter book title: ')
        def title = Console.readLine()
        print('Enter book author: ')
        def author = Console.readLine()
            
        def bk = new Book(catalogNumber : catalogNumber, title : title, author : author)
            
        library.addPublication(bk)
    }

    def addJournal() {
        print('\nEnter journal catalog number: ')
        def catalogNumber = Console.readLine()
        print('Enter journal title: ')
        def title = Console.readLine()
        print('Enter journal editor: ')
        def editor = Console.readLine()
            
        def jo = new Journal(catalogNumber : catalogNumber, title : title, editor : editor)
            
        library.addPublication(jo)
    }
    
    def displayStock() {
        println "\n\nLibrary: ${library.name}"
        println '================'
        
        library.loanStock.each { catalogNumber, publication -> println "    ${publication}" }
    }
    
    def displayPublicationsAvailableForLoan() {
        println "\n\nLibrary: ${library.name} : Available for loan"
        println '================'
        
        library.loanStock.each { catalogNumber, publication -> if(publication.borrower == null) println "    ${publication}" }
    }
    
    def displayPublicationsOnLoan() {
        println "\n\nLibrary: ${library.name} : On loan"
        println '================'
        
        library.loanStock.each { catalogNumber, publication -> if(publication.borrower != null) println "    ${publication}" }
    }
    
    def registerBorrower() {
        print('\nEnter borrower membership number: ')
        def membershipNumber = Console.readLine()
        print('Enter borrower name: ')
        def name = Console.readLine()
        
        def bor = new Borrower(membershipNumber : membershipNumber, name : name)
        
        library.registerBorrower(bor)
    }
    
    def displayBorrowers() {
        println "\n\nLibrary: ${library.name} : Borrower details"
        println '================'
        
        library.borrowers.each { membershipNumber, borrower ->
            println borrower            
            borrower.borrowedPublications.each { catalogNumber, book -> println "    ${book}" }
        }
    }
    
    def lendPublication() {
        print('\nEnter publication catalog number: ')
        def catalogNumber = Console.readLine()
        print('Enter borrower membership number: ')
        def membershipNumber = Console.readLine()
        
        library.lendPublication(catalogNumber, membershipNumber)
    }
    
    def returnPublication() {
        print('\nEnter publication catalog number: ')
        def catalogNumber = Console.readLine()
        
        library.returnPublication(catalogNumber)
    }
    
// ---------- properties ----------------------------------

    private library
}