import groovy.util.GroovyTestCase



class BorrowerTestCase extends GroovyTestCase {

   /** 
    * Set up the fixture
    */
   void setUp(){
        bor1 = new Borrower(membershipNumber : 1234, name : 'P Thompson')
        bk1 = new Book(catalogNumber : 111, title : 'Groovy', author : 'K Barclay')
        bk2 = new Book(catalogNumber : 222, title : 'OOD', author : 'J Savage')
    }

    /**
     * Test that the Borrower has one more Publication on loan
     */
    void testAttachPublication() {
        def pre = bor1.borrowedPublications.size()        
        bor1.attachPublication(bk1)
        def post = bor1.borrowedPublications.size()

        assertTrue('unexpected number of Publications', post == pre + 1)   
    }   
    
     /**
     * Test that the Borrower has one less Publication on loan
     */
    void testDetachPublication() {        
        bor1.attachPublication(bk1)
        bor1.attachPublication(bk2)
        def pre = bor1.borrowedPublications.size() 
        bor1.detachPublication(bk1)
        def post = bor1.borrowedPublications.size() 

        assertTrue('unexpected number of Publications', post == pre - 1)   
    }   

// ---------- properties ----------------------------------

    def bor1
    def bk1
    def bk2
	
}