class Borrower {
    def getBorrowedPublications() {
        return borrowedPublications
    }
    
    def attachPublication(publication) {
        if(!borrowedPublications.containsKey(publication.catalogNumber)) {
            borrowedPublications[publication.catalogNumber] = publication
            publication.attachBorrower(this)
            return true
        }
        else
            return false
    }
    
    def detachPublication(publication) {
        borrowedPublications.remove(publication.catalogNumber)
        publication.detachBorrower()
    }
    
    String toString() {
        return "Borrower: ${membershipNumber}; ${name}"
    }
    
// ---------- properties ----------------------------------

    def membershipNumber
    def name
    def borrowedPublications = [ : ]
    static public final LIMIT = 4

}