/**
 *  A specialized query to obtain all the accounts.
 */

class SpecialAccountQuery extends SqlQuery {

    def SpecialAccountQuery(sql) {
        super(sql, 'select * from accounts')
    }
    
    def mapRow(row) {
        def acc = null
        
        if(row.getProperty('type') == 'CURRENT')
            acc = new CurrentAccount(number : row.getProperty('number'), balance : row.getProperty('balance'), overdraftLimit : row.getProperty('overdraftlimit'))
        else
            acc = new DepositAccount(number : row.getProperty('number'), balance : row.getProperty('balance'), interestRate : row.getProperty('interestrate'))
        
        return acc
    }
    
}
