/**
 *  The DB includes a simple table entitled 'accounts'. This has
 *    two columns named number and balance. A row from this table
 *    represents a simple bank account.
 */

import groovy.sql.*

class Account {

    String toString() {
        return "Account: ${number} ${balance}"
    }
    
// ---------- properties ----------------------------------

    def number
    def balance
}

def DB = 'jdbc:derby:accountDB'
def USER = ''
def PASSWORD = ''
def DRIVER = 'org.apache.derby.jdbc.EmbeddedDriver'

	//  Collection of Account objects
def accounts = []

	//  Connect to database and make query
def sql = Sql.newInstance(DB, USER, PASSWORD, DRIVER)
sql.eachRow('select * from accounts') { acc ->
    accounts << new Account(number : acc.number, balance : acc.balance)
}

	//  Display accounts
accounts.each { acc ->
    println "${acc}"
}
