/**
 *  The DB includes a simple table entitled 'account'. This has
 *    five columns named type, number, balance, overdraftLimit
 *    and interestRate. A row from this table represents some
 *    kind of bank account as denoted by the type.
 */

import groovy.sql.*
import org.springframework.jdbc.datasource.*

def DB = 'jdbc:derby:accountDB'
def USER = ''
def PASSWORD = ''
def DRIVER = 'org.apache.derby.jdbc.EmbeddedDriver'
    
def displayBank(bk) {
    println "Bank: ${bk.name}"
    println '===================='
       
    bk.accounts.each { account -> println "  ${account}" }
    println()
}

def ds = new DriverManagerDataSource(driverClassName : DRIVER, url : DB, username : USER, password : PASSWORD)
def dao = new BankDaoJdbc(dataSource : ds)
def bk = new Bank('Napier', dao)

def da = new Account(number : 'DDD444', balance : 5000)
bk.openAccount(da)

	//  now display everything
displayBank(bk)
