/**
 *  XML to SQL.
 */

import groovy.util.*

def typeToSQL = ['text'		: 'TEXT NOT NULL',
                 'id'		: 'INTEGER NOT NULL',
                 'integer'	: 'INTEGER NOT NULL'
                ]
def parser = new XmlParser()
def doc = parser.parse('tables.xml')

doc.table.each { tab ->
    println "DROP TABLE IF EXISTS ${tab['@name']};"
    println "CREATE TABLE ${tab['@name']}("
    println "    ${tab['@name']}_ID ${typeToSQL['id']},"
    tab.field.each { col ->
        println "    ${col['@name']} ${typeToSQL[col['@type']]},"
    }
    println "    PRIMARY KEY (${tab['@name']}_ID)"
    println ");"
}
