/**
 *  Produce a table of weather values for each city and determine
 *    the lowest recorded value.
 */

import groovy.util.*

def parser = new XmlParser()
def doc = parser.parse('weather.xml')

doc.temperatures.each { temps ->
    def lowest = 200
    println "City: ${temps['@city']}"
    
    println '+------------+----+'
    temps.temperature.each { temp ->
        def tmp = temp.text().toInteger()
        printf('| %10s | %2d |\n', [temp['@date'], tmp])
        if(tmp < lowest)
            lowest = tmp
    }
    println '+------------+----+'
    
    println "Lowest recorded temperature is: ${lowest}"
    println()
}
