/**
 *  Produce a grouping of CDs by their country of origin, then
 *    by their year of publication.
 */

import groovy.util.*
import groovy.xml.*

def countryGrouping(catalog) {
    countryMap = [:]
    
    catalog.cd.each { cd ->
        if(countryMap.containsKey(cd.country[0].text())) {
            def yearMap = countryMap[cd.country[0].text()]
            if(yearMap.containsKey(cd.year[0].text()))
                yearMap[cd.year[0].text()] << cd.title[0].text()
            else
                yearMap[cd.year[0].text()] = [cd.title[0].text()]
        } else {
            countryMap[cd.country[0].text()] = [(cd.year[0].text()) : [cd.title[0].text()]]
        }
    }
    
    return countryMap
}

def parser = new XmlParser()
def doc = parser.parse('catalog.xml')

	//  Create a builder
def mB = new MarkupBuilder(new File('catalog.countries.xml').newPrintWriter())
def groupings = countryGrouping(doc)

mB.grouping() {
    groupings.each { country, yearMap ->
        mB.country(name : country) {
            yearMap.each { year, titleList ->
                mB.year(year : year) {
                    titleList.each { title ->
                        mB.title(title)
                    }
                }
            }
        }
    }
}
