/**
 *  A simple calculator to convert a length measured in imperial
 *    inches to the equivalent amount in centimetres.
 */

import groovy.swing.SwingBuilder
import javax.swing.*
import java.awt.*

	//  Create a builder
def sB = new SwingBuilder()

	// properties
def inputText = null
def outputText = null

	//  Handlers
def doConvert = {
    def text = inputText.getText()
    def inches = text.toInteger()
    def centimetres = 2.54 * inches
    outputText.setText(centimetres.toString())
}

	//  Build the input panel...
def inputPanel = {
    sB.panel() {
        label(text : 'Input the length in inches:', horizontalAlignment : JLabel.RIGHT)
        inputText = textField(text : '', columns : 10)
    }
}

	//  ...then the output panel...
def outputPanel = {
    sB.panel() {
        label(text : 'Converted length in centimetres:', horizontalAlignment : JLabel.RIGHT)
        outputText = textField(text : '', columns : 10, enabled : false)
        button(text : 'Convert', actionPerformed : doConvert)
    }
}

	//  ...and now the main panel
def mainPanel = {
    sB.panel(layout : new GridLayout(2, 3, 5, 5)) {
        inputPanel()
        outputPanel()
    }
}

	//  ...and the frame
def frame = sB.frame(title : 'Example07', location : [100, 100], size : [400, 300], defaultCloseOperation : WindowConstants.EXIT_ON_CLOSE) {
    mainPanel()
}

	//  Now show it
frame.pack()
frame.setVisible(true)
