class Library {
      
    def Library(name, dao) {
    	this.name = name
        this.dao = dao
        
        def bors = dao.getBorrowers()
        bors.each { bor ->
            borrowers[bor.membershipNumber] = bor
        }

        def pubs = dao.getPublications(borrowers)
        pubs.each { pub ->
            loanStock[pub.catalogNumber] = pub
        }   
    }
 
    def addPublication(publication) {
        def message
        if(loanStock.containsKey(publication.catalogNumber)== false){
            // update database
            dao.addPublication(publication)
            // update model
            loanStock[publication.catalogNumber] = publication
            message = 'Publication added'
        }
        else 
            message = 'Cannot add: publication already present'
            
        return message
        
    }

    def removePublication(catalogNumber) {
        def message       
        if(loanStock.containsKey(catalogNumber)== true){
            def publication = loanStock[catalogNumber]
            //
            //note: use of safe navigation             
            publication.borrower?.detachPublication(publication)
            publication.borrower = null            
            loanStock.remove(catalogNumber)
            dao.removePublication(publication)            
            message = 'Publication removed'
        }
        else 
            message = 'Cannot remove: publication not present' 
        
        return message
    }
                     
    def registerBorrower(borrower) {
        def message
        if(borrowers.containsKey(borrower.membershipNumber)== false){
            // update database
            dao.registerBorrower(borrower)
            // update model
            borrowers[borrower.membershipNumber] = borrower
            message = 'Borrower registered'
        }
        else 
            message = 'Cannot register: borrower already registered'
            
        return message
    }
      
    def lendPublication(catalogNumber, membershipNumber) {
        def message
        if(loanStock.containsKey(catalogNumber)== true){
            def publication = loanStock[catalogNumber]
            if(publication.borrower == null){
                if(borrowers.containsKey(membershipNumber)== true){ 
                    def borrower = borrowers[membershipNumber]
                    if(borrower.borrowedPublications.size() < Borrower.LIMIT) {
                        // update database
                        dao.lendPublication(catalogNumber, membershipNumber)
                        // update model 
                        borrower.attachPublication(publication)
                        this.checkPublicationBorrowerLoopInvariant('Library.lendPublication')
                        message = 'Publication loaned'
                    }
                    else 
                        message = 'Cannot lend: borrower over limit'                                        
                }
                else 
                    message = 'Cannot lend: borrower not registered'             
            }
            else 
                message = 'Cannot lend: publication already on loan'            
        }
        else 
            message = 'Cannot lend: publication not present'
        
        return message
    }
  
    def returnPublication(catalogNumber) {
        def message
        if(loanStock.containsKey(catalogNumber)== true){
            def publication = loanStock[catalogNumber]
            if(publication.borrower != null){
                // update database 
                dao.returnPublication(catalogNumber)
                // update model
                publication.borrower.detachPublication(publication)
                message = 'Publication returned'
            }
            else 
                message = 'Cannot return: publication not on loan'            
        }
        else 
            message = 'Cannot return: publication not present'
            
        return message        
    }  

    private checkPublicationBorrowerLoopInvariant(methodName) {
        def publications = loanStock.values().asList()

        def onLoanPublications = publications.findAll{ publication -> publication.borrower != null }
     
        def allOK = onLoanPublications.every{ publication ->
             publication.borrower.borrowedPublications.containsKey(publication.catalogNumber)
        }  
        
        if( allOK == false ){
            throw new Exception("${methodName}: Invariant failed")
        }
    }  
   
// ---------- properties ----------------------------------

    def name
    def loanStock = [ : ]
    def borrowers = [ : ]
    def dao
    
}