/**
 *  Searching a Map to find all the keys that match a regular expression
 *    pattern. The result is a List of sub-Lists with the key and value.
 */

class MapCategory {

    static List search(Map map, String pattern) {
        def res = []
        map.each { key, value ->
            if(key =~ pattern)
                res << [key, value]
        }
        return res
    }
}

use(MapCategory.class) {
    def map = ['Ken' : 'Barclay', 'John' : 'Savage', 'Jon' : 'Kerridge']
    def res = map.search('Jo')
    println "Result: ${res}"
}
 