package extras

/**
 *  Apply some transformation f to every element of some list.
 *    Effectively, given a function f and a list = [x1, x2, ...]
 *    then the new list = [f(x1), f(x2), ...].
 *
 *  Obtain the transformation by currying closures.
 */

def map = { f, list ->
    return list.collect(f)
}

def multiply = { x, y -> return x * y }
def twice = multiply.curry(2)
def quadruple = multiply.curry(4)

def twiceAll = map.curry(twice)
def quadrupleAll = map.curry(quadruple)

println "twiceAll: ${twiceAll([1, 2, 3, 4])}"
println "twiceAll: ${twiceAll([])}"

println "quadrupleAll: ${quadrupleAll([1, 2, 3, 4])}"
println "quadrupleAll: ${quadrupleAll([])}"
   