package extras

/**
 *  Apply some transformation f to every element of some list.
 *    Effectively, given a function f and a list = [x1, x2, ...]
 *    then the new list = [f(x1), f(x2), ...].
 *
 *  The transformation closure is obtained by composing simpler closures.
 */

def map = { f, list ->
    return list.collect(f)
}

def composition = { f, g, x -> return f(g(x)) }

def multiply = { x, y -> return x * y }
def twice = multiply.curry(2)

def quadrupleAll = map.curry(composition.curry(twice, twice))

println "quadrupleAll: ${quadrupleAll([1, 2, 3, 4])}"
println "quadrupleAll: ${quadrupleAll([])}"
 