package extras

/**
 *  Select all those elements from a list of integers that are
 *    both even and greater than three. The predicate is formed
 *    by composing two simpler predicates.
 */

import fp.*

	// aliasing
def rGt = Functor.rGt
def bAnd = Functor.bAnd
def bComposition = Functor.bComposition
def map = Functor.map
def filter = Functor.filter

	// simple and composed predicates
def isEven = { x -> return (x % 2 == 0) }
def gt3 = rGt.curry(3)
def evenAndGt3 = bComposition.curry(bAnd, isEven, gt3)

def ex = [2, 4, 7]
def res = filter(evenAndGt3, ex)
println "res: ${res}"
