package extras

/**
 *  Currying the equality predicate bEq we can define
 *    isMember in terms of the built-in any iterator method.
 */

import fp.*

	// alias
def bEq = Functor.bEq

def isMember = { item, list ->
    def isEqual = bEq.curry(item)
    return list.any(isEqual)
}

def ex = [11, 12, 13, 14]
println "isMember: ${isMember(12, ex)}"
println "isMember: ${isMember(15, ex)}"
