package extras

/**
 *  The function disjoint tests whether two lists
 *    have no elements in common. This is implemented
 *    with nested evaluation of method every. In effect
 *    disjoint tests for all x in list1 and all y in list2,
 *    x != y.
 */

import fp.*

	// alias
def bNe = Functor.bNe

def disjoint = { list1, list2 ->
    return list1.every {item1 -> return list2.every {item2 -> return bNe(item1, item2)} }
}

def ex1 = [11, 12, 13, 14]
def ex2 = [15, 16]
def ex3 = [14, 15]
           
println "disjoint: ${disjoint(ex1, ex2)}"
println "disjoint: ${disjoint(ex1, ex3)}"
