/**
 *  A category to augment the List class with the method removeIf to
 *    remove those elements in a List that satisfy some predicate.
 */

class ListCategory {

    static List removeIf(List self, Closure predicate) {
        def answer = []
        self.each { elem ->
            if( ! predicate(elem))
                answer << elem
        }
        self.clear()
        self.addAll(answer)
        return self
    }
}

use(ListCategory) {
    def numbers = [11, 12, 13, 14, 15]
    def evens = numbers.removeIf { num -> return (num % 2 == 1) }
    println "Evens: ${evens}"
}
