package fp



/**
 *  The Functor class contains a series of static closures that
 *    support functional programming constructs.
 */

abstract class Functor {

		//  arithmetic (binary, left commute and right commute)
    public static Closure bAdd			= { x, y -> return x + y }
    public static Closure rAdd			= { y, x -> return x + y }
    public static Closure lAdd			= { x, y -> return x + y }
    
    public static Closure bSubtract		= { x, y -> return x - y }
    public static Closure rSubtract		= { y, x -> return x - y }
    public static Closure lSubtract		= { x, y -> return x - y }
    
    public static Closure bMultiply		= { x, y -> return x * y }
    public static Closure rMultiply		= { y, x -> return x * y }
    public static Closure lMultiply		= { x, y -> return x * y }
    
    public static Closure bDivide		= { x, y -> return x / y }
    public static Closure rDivide		= { y, x -> return x / y }
    public static Closure lDivide		= { x, y -> return x / y }
    
    public static Closure bModulus		= { x, y -> return x % y }
    public static Closure rModulus		= { y, x -> return x % y }
    public static Closure lModulus		= { x, y -> return x % y }
    
    
    
    		//  relational
    public static Closure bLt			= { x, y -> return x < y }
    public static Closure rLt			= { y, x -> return x < y }
    public static Closure lLt			= { x, y -> return x < y }
    
    public static Closure bLe			= { x, y -> return x <= y }
    public static Closure rLe			= { y, x -> return x <= y }
    public static Closure lLe			= { x, y -> return x <= y }
    
    public static Closure bGt			= { x, y -> return x > y }
    public static Closure rGt			= { y, x -> return x > y }
    public static Closure lGt			= { x, y -> return x > y }
    
    public static Closure bGe			= { x, y -> return x >= y }
    public static Closure rGe			= { y, x -> return x >= y }
    public static Closure lGe			= { x, y -> return x >= y }
    
    public static Closure bEq			= { x, y -> return x == y }
    public static Closure rEq			= { y, x -> return x == y }
    public static Closure lEq			= { x, y -> return x == y }
    
    public static Closure bNe			= { x, y -> return x != y }
    public static Closure rNe			= { y, x -> return x != y }
    public static Closure lNe			= { x, y -> return x != y }
    
    
    
    		//  logical
    public static Closure bAnd			= { x, y -> return x && y }
    public static Closure rAnd			= { y, x -> return x && y }
    public static Closure lAnd			= { x, y -> return x && y }
    
    public static Closure bOr			= { x, y -> return x || y }
    public static Closure rOr			= { y, x -> return x || y }
    public static Closure lOr			= { x, y -> return x || y }
    
    
    
    		//  min/max
    public static Closure bMin			= { x, y -> return (x < y) ? x : y }
    public static Closure bMax			= { x, y -> return (x < y) ? y : x }
    
    
    
    		//  identity
    public static Closure id			= { x -> return x }
    
    public static Closure konst			= { x, y -> return y }
    
    
    
    		// composition
    public static Closure composition		= { f, g, x -> return f(g(x)) }
    
    public static Closure bComposition		= { h, f, g, x -> return h(f(x), g(x)) }
    
    
    
    		// lists
    public static Closure head			= { list -> return (list.size() == 0) ? null : list[0] }
    
    public static Closure tail			= { list -> return (list.size() == 0) ? [] : list[1..<list.size()] }
    
    /*****
    public static Closure tail			= { list ->
    						        if(list.size() == 0)
    						            return []
    						        else {
    						            def copy = []
    						            copy.addAll(list)
    						            copy.remove(0)
    						            return copy
    						        }
    						  }
    						  *****/
    
    public static Closure cons			= { item, list ->
    						        def copy = list.clone()
    						        copy.add(0, item)
    						        return copy
    						  }
    
    /*****
    public static Closure cons			= { item, list ->
    						        def copy = []
    						        copy.addAll(list)
    						        copy.add(0, item)
    						        return copy
    						  }
    						  *****/
    						  
    public static Closure map			= { action, list -> return list.collect(action) }
    
    public static Closure apply			= { action, list -> list.each(action) }
    
    public static Closure filter		= { predicate, list -> return list.findAll(predicate) }
    
    public static Closure take			= { n, list -> return list[0..<n] }
    
    public static Closure drop			= { n, list -> return list[n..<list.size()] }
            
    public static Closure takeWhile		= { predicate, list ->
                                                      if(list.size() == 0)
                                                          return []
                                                      else if(predicate(list[0]))
                                                          return cons.call(list[0], this.call(predicate, list[1..<list.size()]))
                                                  }
            
    /*****
    public static Closure takeWhile		= { predicate, list ->
                                                      def res = []
                                                      for(element in list) {
                                                          if(predicate(element)) {
                                                              res << element
                                                          }
                                                      }
                                                      return res
                                                  }
                                                  *****/
            
    public static Closure dropWhile		= { predicate, list ->
                                                      if(list.size() == 0)
                                                          return []
                                                      else if(predicate(list[0]))
                                                          return this.call(predicate, list[1..<list.size()])
                                                  }
            
    /*****
    public static Closure dropWhile		= { predicate, list ->
                                                      def size = list.size()
                                                      for(index in 0..<size) {
                                                          if(predicate(list[index]) == false) {
                                                              return list[index..<size]
                                                          }
                                                      }
                                                      return []
                                                  }
                                                  *****/
    
    /*****
    public static Closure forAll		= { predicate, list ->
                                                      if(list.size() == 0)
                                                          return true
                                                      else if(predicate(list[0]))
                                                          return this.call(predicate, list[1..<list.size()])
                                                      else
                                                          return false
                                                  }
                                                  *****/
    
    public static Closure forAll		= { predicate, list ->
                                                      for(element in list) {
                                                          if(predicate(element) == false) {
                                                              return false
                                                          }
                                                      }
                                                      return true
                                                  }
    
    public static Closure thereExists		= { predicate, list ->
                                                      if(list.size() == 0)
                                                          return false
                                                      else if(predicate(list[0]))
                                                          return true
                                                      else
                                                          return this.call(predicate, list[1..<list.size()])
                                                  }
    
    /*****
    public static Closure thereExists		= { predicate, list ->
                                                      for(element in list) {
                                                          if(predicate(element)) {
                                                              return true
                                                          }
                                                      }
                                                      return false
                                                  }
                                                  *****/
    
    public static Closure thereExistsUnique	= { predicate, list ->
                                                      def subList = list.findAll(predicate)
                                                      return subList.size() == 1
                                                  }
    
    
    ////public static Closure lFold			= { f, e, list -> return (list.size() == 0) ? e : this.call(f, f(e, list[0]), list[1..<list.size()]) }
    
    public static Closure lFold			= { f, e, list ->
    					              def res = e
    					              for(element in list) {
    					                  res = f(element, res)
    					              }
    					              return res
    					          }
    
    /*****
    public static Closure rFold			= { f, e, list ->
    						      if(list.size() == 0)
    						          return e
    						      else {
    						          def res = this.call(f, e, list[1..<list.size()])
    						          return f(list[0], res)
    						      }
    						          //return f(list[0], this.call(f, e, list[1..<list.size()]))
    						  }
    *****/
    
    public static Closure rFold			= { f, e, list ->
    					              def size = list.size()
    					              def res = e
    					              for(index in 0..<size) {
    					                  res = f(list[size - 1 - index], res)
    					              }
    					              return res
    					          }

    public static Closure summation		= rFold.curry(bAdd, 0)
    
    public static Closure product		= rFold.curry(bMultiply, 1)
    
    public static Closure isAllTrue		= lFold.curry(bAnd, true)
    
}
