def head(list) {
    return (list.size() == 0) ? null : list[0]
}

def tail(list) {
    def size = list.size()
    return (size == 0) ? [] : list[1..<size]
}

def cons(item, list) {
    def copy = list
    copy.add(0, item)
    return copy
}

def successors(node, graph) {
    if(graph.size() == 0)
        return []
    else {
        def hd = head(graph)
        if(node == hd[0])
            return cons(hd[1], successors(node, tail(graph)))
        else
            return successors(node, tail(graph))
    }
}

def depthF(nodes, graph, visited) {
    if(nodes.size() == 0)
        return visited.reverse()
    else {
        hd = head(nodes)
        if(visited.contains(hd) == true)
            return depthF(tail(nodes), graph, visited)
        else {
            def nList = successors(hd, graph)
            nList.addAll(tail(nodes))
            return depthF(nList, graph, cons(hd, visited))
        }
    }
}

def depthFirst(node, graph) {
    return depthF([node], graph, [])
}

def graph = [['a', 'b'], ['a', 'c'], ['a', 'd'],
             ['b', 'e'], ['c', 'f'], ['d', 'e'],
             ['e', 'f'], ['e', 'g']
            ]

println "depthFirst: ${depthFirst('a', graph)}"
