def head(list) {
    return (list.size() == 0) ? null : list[0]
}

def tail(list) {
    def size = list.size()
    return (size == 0) ? [] : list[1..<size]
}

def cons(item, list) {
    def copy = list
    copy.add(0, item)
    return copy
}

def append(list1, list2) {
    def result = []
    result.addAll(list1)
    result.addAll(list2)
    return result
}

def partition(left, right, list, pivot) {
    if(list.size() == 0) {
        return append(quickSort(left), cons(pivot, quickSort(right)))
    } else {
        def hd = head(list)
        def tl = tail(list)
        if(hd <= pivot)
            return partition(cons(hd, left), right, tl, pivot)
        else
            return partition(left, cons(hd, right), tl, pivot)
    }
}

def quickSort(list) {
    if(list.size() == 0)
        return []
    else if(list.size() == 1)
        return [head(list)]
    else {
        def hd = head(list)
        def tl = tail(list)
        return partition([], [], tl, hd)
    }
}

println "sort: ${quickSort([14, 11, 15, 13, 12])}"
