import java.util.*
import console.*

def head(list) {
    return (list.size() == 0) ? null : list[0]
}

def tail(list) {
    def size = list.size()
    return (size == 0) ? [] : list[1..<size]
}

def cons(item, list) {
    def copy = list
    copy.add(0, item)
    return copy
}

def maxList(list) {
    def max = list[0]
    for(k in 1..<list.size())
        if(max < list[k])
            max = list[k]
    return max
}

def intToRoman(arabic) {
    return changeRoman(arabic, [1 : 'I', 5 : 'V', 10 : 'X', 50 : 'L', 100 : 'C', 500 : 'D', 1000 : 'M'])
}

def changeRoman(arabic, romanMap) {
    def keyList = romanMap.keySet().toArray()
    def max = maxList(keyList)
    if(arabic == 0)
        return []
    else if(arabic < max) {
        def copy = [:]
        copy.putAll(romanMap)
        copy.remove(max)
        return changeRoman(arabic, copy)
    } else {
        return cons(romanMap[max], changeRoman(arabic - max, romanMap))
    }
}

def romanToInt(roman) {
    def ROMAN = ['M' : 1000, 'D' : 500, 'C' : 100, 'L' : 50, 'X' : 10, 'V' : 5, 'I' : 1]
    def arabic = roman.toList().inject(0) { previous, romanDigit -> return previous + ROMAN[romanDigit] }
    return arabic
}

print "Enter decimal value: "
def arabic = Console.readInteger()

def roman = intToRoman(arabic).join('')
println "Arabic: ${arabic}"
println "Roman: ${roman}"
println "And back to arabic: ${romanToInt(roman)}"
