def findManagerOf(name, staff) {
    def staffEntry = staff.find { entry -> entry.value.contains(name) }
    return (staffEntry == null) ? null : staffEntry.key
}

def findNoManager(staff) {
    def result = []
    staff.each { manager, team ->
        def man = findManagerOf(manager, staff)
        if(man != null && result.contains(man) == false) result << man
    }
    return result
}

def staff = ['Ken' : ['John', 'Peter'],
             'Jon' : ['Ken', 'Jessie'],
             'Jessie' : ['Jim', 'Tom']
            ]
println "Manager of Ken: ${findManagerOf('Ken', staff)}"
println "Manager of Jon: ${findManagerOf('Jon', staff)}"

println "findNoManager: ${findNoManager(staff)}"
