def printRoom(room) {
    switch(room[0]) {
        case 'Bedroom' :
            println "Bedroom: ${room[1]}"
            break;
        case 'Studyroom' :
            println "Studyroom: ${room[1]}"
            break;
        case 'Conferenceroom' :
            println "Conferenceroom: ${room[1]} ${room[2]}"
            break;
    }
}

def printAllRooms(hotel) {
    println "Hotel"
    println "=========="
    
    hotel.each { floorNumber, rooms ->
        println "  Floor: ${floorNumber}"
        rooms.each { roomNumber, room ->
            print "    ${roomNumber}: "
            printRoom(room)
        }
    }
    println""
}

def printRoomsOnFloor(hotel, floorNumber) {
    println "Hotel (Floor: ${floorNumber})"
    println "=========="
    
    def rooms = hotel[floorNumber]
    rooms.each { roomNumber, room ->
        print "    ${roomNumber}: "
        printRoom(room)
    }
}

def hotel = [1 : [1 : ['Bedroom', 2], 2 : ['Bedroom', 4], 3 : ['Studyroom', 10]],
             2 : [1 : ['Bedroom', 4], 2 : ['Bedroom', 4]],
             3 : [1 : ['Bedroom', 4], 2 : ['Conferenceroom', 25, 'Balmoral']]
            ]

printAllRooms(hotel)

printRoomsOnFloor(hotel, 2)