/**
 *  exercise01
 *  advantage: easy to use, what you see is what you get
 *  disadvantage: normal code formatting is not possible
 */

import textio.*

def addBook(library, bookTitle) {
    library[bookTitle]= []
}

def removeBook(library, bookTitle) {  
    library.remove(bookTitle)      
}

def lendBook(library, bookTitle, borrowerName) {
    library[bookTitle] << borrowerName       
}


def returnBook(library, bookTitle, borrowerName) {
    library[bookTitle].remove(borrowerName)
}

def writeLoanStock(library) {
    println "\nLibrary stock: ${library} \n"
}

def readNumberBorrowedBooks(library, borrowerName) {
    def borrowerNames = library.values().toList()
    borrowerNames = borrowerNames.flatten()
    return borrowerNames.count(borrowerName)
}

def readNumberBorrowers(library, bookName) {
    return library[bookName].size()
}

def readBookTitle(){
    ConsoleIO.out.print("\tEnter book title: ")
    return ConsoleIO.in.readLine()
}

def readBorrowerName(){
    ConsoleIO.out.print("\tEnter borrower name: ")
    return ConsoleIO.in.readString()
}

def readMenuSelection(){
    ConsoleIO.out.print('''
    0: Quit
    1: Add new book
    2: Remove book
    3: Lend a book
    4: Return a book
    5: Display loan stock
    6: Display number of books on loan to a borrower
    7: Display number of borrowers of a book
       
        Enter choice: ''')      
    return ConsoleIO.in.readString()
} 


def library = ['Groovy' : ['Ken', 'John'],
               'OOD' : ['Ken'],
               'Java' : ['John', 'Sally'],
               'UML' : ['Sally'],
               'Basic' : []
              ]
    
def choice = readMenuSelection()

while(choice != '0'){
    
    if(choice == '1'){      
        addBook(library, readBookTitle())
    }
    else if(choice == '2'){
        removeBook(library, readBookTitle())   
    }
    else if(choice == '3'){
        lendBook(library, readBookTitle(), readBorrowerName())
    }
    else if(choice == '4'){
        returnBook(library, readBookTitle(), readBorrowerName())
    }
    else if(choice == '5'){
        writeLoanStock(library)
    }
    else if(choice == '6'){
        def count = readNumberBorrowedBooks(library, readBorrowerName())
        println "\nNumber of books borrowed: ${count}\n"
    }
    else if(choice == '7'){
        def count = readNumberBorrowers(library, readBookTitle())
        println "\nNumber of borrowers: ${count}\n"
    }
    else {
        ConsoleIO.out.println("\nUnknown selection\n")
    }
      // next selection
    choice = readMenuSelection()
}
ConsoleIO.out.println("\nSystem closing\n")