/**
 *  exercise03
 *
 */

import textio.*

def addBook(library, bookTitle) {
    library[bookTitle]= []
}

def removeBook(library, bookTitle) {  
    library.remove(bookTitle)      
}

def lendBook(library, bookTitle, borrowerName) {
    library[bookTitle] << borrowerName       
}


def returnBook(library, bookTitle, borrowerName) {
    library[bookTitle].remove(borrowerName)
}

def writeLoanStock(library) {
    println "\nLibrary stock: ${library} \n"
}

def readNumberBorrowedBooks(library, borrowerName) {
    def borrowerNames = library.values().toList()
    borrowerNames = borrowerNames.flatten()
    return borrowerNames.count(borrowerName)
}

def readNumberBorrowers(library, bookTitle) {
    return library[bookTitle].size()
}

def readBorrowers(library, bookTitle) {
    return library[bookTitle]
}

def readAllBorrowers(library) {
    def borrowerNames = library.values().toList()
    borrowerNames = borrowerNames.flatten()
    borrowerNames = new HashSet(borrowerNames)
    return borrowerNames
}

def readBookTitle(){
    ConsoleIO.out.print("\tEnter book title: ")
    return ConsoleIO.in.readLine()
}

def readBorrowerName(){
    ConsoleIO.out.print("\tEnter borrower name: ")
    return ConsoleIO.in.readString()
}

def readMenuSelection(){
    ConsoleIO.out.print('''
    0: Quit
    1: Add new book
    2: Remove book
    3: Lend a book
    4: Return a book
    5: Display loan stock
    6: Display number of books on loan to a borrower
    7: Display number of borrowers of a book
    8: Display borrowers of a book
    9: Display all borrowers
       
        Enter choice: ''')      
    return ConsoleIO.in.readString()
} 


def library = ['Groovy' : ['Ken', 'John'],
               'OOD' : ['Ken'],
               'Java' : ['John', 'Sally'],
               'UML' : ['Sally'],
               'Basic' : []
              ]
    
def choice = readMenuSelection()

while(choice != '0'){
    
    if(choice == '1'){      
        addBook(library, readBookTitle())
    }
    else if(choice == '2'){
        removeBook(library, readBookTitle())   
    }
    else if(choice == '3'){
        lendBook(library, readBookTitle(), readBorrowerName())
    }
    else if(choice == '4'){
        returnBook(library, readBookTitle(), readBorrowerName())
    }
    else if(choice == '5'){
        writeLoanStock(library)
    }
    else if(choice == '6'){
        def count = readNumberBorrowedBooks(library, readBorrowerName())
        println "\nNumber of books borrowed: ${count}\n"
    }
    else if(choice == '7'){
        def count = readNumberBorrowers(library, readBookTitle())
        println "\nNumber of borrowers: ${count}\n"
    }
    else if(choice == '8'){
        def borrowerNames = readBorrowers(library, readBookTitle())
        println "\nBorrowers: ${borrowerNames.sort()}\n"
        
    }
    else if(choice == '9'){
        def borrowerNames = readAllBorrowers(library)
        println "\nBorrowers: ${borrowerNames.sort()}\n" 
    }
    else {
        ConsoleIO.out.println("\nUnknown selection\n")
    }
      // next selection
    choice = readMenuSelection()
}
ConsoleIO.out.println("\nSystem closing\n")