/**
 *  A library comprises a stock of books. Associated with each book
 *  title there is a list of the name of each borrower. If the list
 *  is empty then the book is not on loan to any borrower.
 *
 */

import textio.*

def readBookTitle(){
    ConsoleIO.out.print("\tEnter book title: ")
    return ConsoleIO.in.readLine()
}

def readBorrowerName(){
    ConsoleIO.out.print("\tEnter borrower name: ")
    return ConsoleIO.in.readString()
}

def readMenuSelection(){
    ConsoleIO.out.println()
    ConsoleIO.out.println("0: Quit")
    ConsoleIO.out.println("1: Add new book")
    ConsoleIO.out.println("2: Remove book")
    ConsoleIO.out.println("3: Lend a book")
    ConsoleIO.out.println("4: Return a book")
    ConsoleIO.out.println("5: Display loan stock")
    ConsoleIO.out.println("6: Display number of books on loan to a borrower")
    ConsoleIO.out.println("7: Display number of borrowers of a book")
       
    ConsoleIO.out.print("\n\tEnter choice: ")      
    return ConsoleIO.in.readString()
} 

def library = ['Groovy' : ['Ken', 'John'],
               'OOD' : ['Ken'],
               'Java' : ['John', 'Sally'],
               'UML' : ['Sally'],
               'Basic' : []
              ]


def doAddBook = {
    def addBook = { bookTitle -> library[bookTitle] = [] }
    addBook.call(readBookTitle())		// explicit call
}

def doRemoveBook = {
    def removeBook = { bookTitle -> library.remove(bookTitle) }
    removeBook(readBookTitle())			// implicit call
}

def doLendBook = {
    def lendBook = { bookTitle, borrowerName -> library[bookTitle] << borrowerName  }
    lendBook(readBookTitle(), readBorrowerName())
}

def doReturnBook = {
    def returnBook = { bookTitle, borrowerName -> library[bookTitle].remove(borrowerName)  }
    returnBook(readBookTitle(), readBorrowerName())
}

def doDisplayLoanStock = {
    def writeLoanStock = { println "\nLibrary stock: ${library} \n" }
    writeLoanStock()
}

def doDisplayNumberBooksOnLoanToBorrower = {
    def displayNumberBooksOnLoanToBorrower = { borrowerName ->
        def borrowerNames = library.values().toList()
        borrowerNames = borrowerNames.flatten()
        println "\nNumber of books borrowed: ${borrowerNames.count(borrowerName)}\n"
    }
    displayNumberBooksOnLoanToBorrower(readBorrowerName())
}

def doDisplayNumberBorrowersOfBook = {
    def displayNumberBorrowersOfBook = { bookTitle ->
        println "\nNumber of borrowers: ${library[bookTitle].size()}\n"
    }
    displayNumberBorrowersOfBook(readBookTitle())
}

def menu = [ '1' : doAddBook, '2' : doRemoveBook,
             '3' : doLendBook,'4' : doReturnBook,
             '5' : doDisplayLoanStock, '6' : doDisplayNumberBooksOnLoanToBorrower,
             '7' : doDisplayNumberBorrowersOfBook
             
           ]
   
def choice = readMenuSelection()
while(choice != '0'){
    menu[choice].call()  
    choice = readMenuSelection()
}
ConsoleIO.out.println("\nSystem closing\n")