class Point {
    
    def moveBy(xOffset, yOffset) {
        x += xOffset
        y += yOffset
    }
    
    String toString() {
        return "Point(${x}, ${y})"
    }
    
// ---------- properties ----------------------------------

    @Property x
    @Property y
}



class Line {
    
    def moveBy(xOffset, yOffset) {
        start.moveBy(xOffset, yOffset)
        end.moveBy(xOffset, yOffset)
    }
    
    def isHorizontal() {
        return (start.y == end.y)
    }
    
    def isVertical() {
        return (start.x == end.x)
    }
    
    String toString() {
        return "Line: ${start} ${end}"
    }
    
// ---------- properties ----------------------------------

    @Property start
    @Property end
}



def line = new Line(start : new Point(x : 5, y : 5), end : new Point(x : 10, y : 5))

line.moveBy(2, 2)

println "line: ${line}"

println "isHorizontal: ${line.isHorizontal()}"
println "isVertical: ${line.isVertical()}"
