class Employee {

    String toString() {
        return "Employee: ${staffNumber} ${name} ${salary}"
    }
    
// ---------- properties ----------------------------------

    @Property staffNumber
    @Property name
    @Property salary
}



class Company {
    
    def hire(employee) {
        employees[employee.staffNumber] = employee
    }
    
    def display() {
        println "Company: ${name}"
        println "===================="
        
        employees.each { staffNumber, employee -> println "    ${employee}" }
    }
    
    def getTotalSalaries() {
        def total = 0
        employees.each { staffNumber, employee -> total += employee.salary }
        return total
    }
    
// ---------- properties ----------------------------------

    @Property name
    @Property employees = [ : ]
}



def co = new Company(name : 'Napier')

co.hire(new Employee(staffNumber : 111, name : 'K Barclay', salary : 1000))
co.hire(new Employee(staffNumber : 222, name : 'J Savage', salary : 1200))
co.hire(new Employee(staffNumber : 333, name : 'J Kerridge', salary : 2000))

co.display()

println "Total salaries: ${co.getTotalSalaries()}"
