class Employee {

    String toString() {
        return "Employee: ${staffNumber} ${name} ${salary}"
    }
    
// ---------- properties ----------------------------------

    @Property staffNumber
    @Property name
    @Property salary
}



class Department {
    
    def add(employee) {
        employees[employee.staffNumber] = employee
    }
    
    def display() {
        println "  Department: ${name}"
        println "  -------------------"
        
        employees.each { staffNumber, employee -> println "    ${employee}" }
        println()
    }
    
    def getTotalSalaries() {
        def total = 0
        employees.each { staffNumber, employee -> total += employee.salary }
        return total
    }
    
// ---------- properties ----------------------------------

    @Property name
    @Property employees = [ : ]
}



class Company {
    
    def open(department) {
        departments[department.name] = department
    }
    
    def hire(deptName, employee) {
        departments[deptName].add(employee)
    }
    
    def display() {
        println "Company: ${name}"
        println "===================="
        
        departments.each { name, department -> department.display() }
    }
    
    def getTotalSalaries() {
        def total = 0
        departments.each { name, department -> total += department.getTotalSalaries() }
        return total
    }
    
// ---------- properties ----------------------------------

    @Property name
    @Property departments = [ : ]
}



def co = new Company(name : 'Napier')

co.open(new Department(name : 'Merchiston'))
co.open(new Department(name : 'Craiglockhart'))

co.hire('Merchiston', new Employee(staffNumber : 111, name : 'K Barclay', salary : 1000))
co.hire('Merchiston', new Employee(staffNumber : 222, name : 'J Savage', salary : 1200))
co.hire('Craiglockhart', new Employee(staffNumber : 333, name : 'J Kerridge', salary : 2000))

co.display()

println "Total salaries: ${co.getTotalSalaries()}"
