class Customer {

    def add(newspaper) {
        newspapers << newspaper
    }
    
    String toString() {
        return "Customer: ${name}"
    }
    
// ---------- properties ----------------------------------

    @Property name
    @Property newspapers = []
}



class Newsagent {
    
    def add(customer) {
        customers[customer.name] = customer
    }
    
    def getNewspapers() {
        def newspaperOrders = [:]
        customers.each { name, customer ->
            customer.newspapers.each { newspaper ->
                if(newspaperOrders.keySet().contains(newspaper) == true)
                    newspaperOrders[newspaper] = 1 + newspaperOrders[newspaper]
                else
                    newspaperOrders[newspaper] = 1
            }
        }
        return newspaperOrders
    }
    
// ---------- properties ----------------------------------

    @Property name
    @Property customers = [:]
}



def na = new Newsagent(name : 'Cornershop')

def cust1 = new Customer(name : 'K Barclay')
def cust2 = new Customer(name : 'J Savage')
def cust3 = new Customer(name : 'J Kerridge')

cust1.add('Scotsman')
cust1.add('Herald')

cust2.add('Scotsman')
cust2.add('Record')

cust3.add('Express')

na.add(cust1)
na.add(cust2)
na.add(cust3)

println "getNewspapers: ${na.getNewspapers()}"
