/**
 *  XXX
 */

import textio.*



class Car {
    
    def attachCustomer(customer) {
        this.customer = customer
    }
    
    def detachCustomer() {
        customer = null
    }
    
    String toString() {		// redefinition
        return "Car: ${registrationNumber}, ${make}, ${model}, ${year}"
    }
    
// ---------- properties ----------------------------------

    @Property registrationNumber
    @Property make
    @Property model
    @Property year
    @Property customer = null
    
}



class Customer {
    
    def attachCar(car) {
        hiredCars[car.registrationNumber] = car
        car.attachCustomer(this)
    }
    
    def detachCar(car) {
        hiredCars.remove(car.registrationNumber)
        car.detachCustomer()
    }
    
    String toString() {
        return "Customer: ${customerNumber}; ${name}"
    }
    
// ---------- properties ----------------------------------

    @Property customerNumber
    @Property name
    @Property hiredCars = [ : ]
}



class Company {
        
    def addCar(car) {
        carStock[car.registrationNumber] = car
    }
    
    def displayCars() {
        println "Company: ${name}"
        println "======================"
        
        carStock.each { entry -> println "    ${entry.value}" }
    }
    
    def displayCarsAvailableForHire() {
        println "Company: ${name}"
        println "Available for hire"
        println "======================"
        
        carStock.each { entry -> if(entry.value.customer == null) println "    ${entry.value}" }
    }
    
    def displayCarsOnHire() {
        println "Company: ${name}"
        println "On hire"
        println "======================"
        
        carStock.each { entry -> if(entry.value.customer != null) println "    ${entry.value}" }
    }

    def registerCustomer(customer) {
        customers[customer.customerNumber] = customer
    }
    
    def displayCustomers() {
        println "Company: ${name}"
        println "======================"
        
        customers.each { entry ->
            def cust = entry.value
            println cust
            
            cust.hiredCars.each { entry -> println "    ${entry.value}" }
        }
    }

    def hireCar(registrationNumber, customerNumber) {
        def car = carStock.find { entry -> entry.key == registrationNumber }
        def cust = customers.find { entry -> entry.key == customerNumber }
        cust.value.attachCar(car.value)
    }
    
    def returnCar(registrationNumber) {
        def car = carStock.find { entry -> entry.key == registrationNumber }
        def cust = car.value.customer
        cust.detachCar(car.value)
    }

// ---------- properties ----------------------------------

    @Property name
    @Property carStock = [ : ]
    @Property customers = [ : ]
}



	//  Create a company object
def comp = new Company(name : 'Dunning')

	//  Create some cars...
def car1 = new Car(registrationNumber : 111, make : 'Ford', model : 'Mondeo', year : 2004)
def car2 = new Car(registrationNumber : 222, make : 'Renault', model : 'Laguna', year : 2005)
def car3 = new Car(registrationNumber : 333, make : 'BMW', model : 'Series 3', year : 2005)

	//  ...add then to the hire stock
comp.addCar(car1)
comp.addCar(car2)
comp.addCar(car3)

	//  See stock
comp.displayCars()



	//  Now introduce some customers
cust1 = new Customer(customerNumber : 1234, name : 'Jessie')
cust2 = new Customer(customerNumber : 5678, name : 'Sally')


comp.registerCustomer(cust1)
comp.registerCustomer(cust2)

	//  See borrowers
comp.displayCustomers()



	//  Finally, make some transactions
comp.displayCarsAvailableForHire()

comp.hireCar(111, 1234)

comp.displayCarsAvailableForHire()
comp.displayCarsOnHire()
comp.displayCustomers()



comp.returnCar(111)

comp.displayCarsAvailableForHire()
comp.displayCarsOnHire()
comp.displayCustomers()
