/**
 *  An illustration of class specialization. Class CurrentAccount
 *    is defined as a specialization of the class Account. The abstract
 *    Account class also implements the interface AccountIF. Here is
 *    where the abstract method display is introduced.
 */

interface AccountIF {

    abstract display()		// deferred method
}



abstract class Account implements AccountIF {

    String toString() {		// redefinition
        return "${number}; ${balance}"
    }
    
    def display() {
        println '  ' + this
    }
    
// ---------- properties ----------------------------------

    @Property number
    @Property balance
    
}



class CurrentAccount extends Account {

    String toString() {
        return 'Current Account: ' + super.toString() + "; ${overdraftLimit}"
    }
    
// ---------- properties ----------------------------------

    @Property overdraftLimit
}



class DepositAccount extends Account {

    String toString() {
        return 'Deposit Account: ' + super.toString() + "; ${interestRate}"
    }
    
// ---------- properties ----------------------------------

    @Property interestRate
}



class Bank {
    
    def openAccount(account) {
        accounts[account.getNumber()] = account
    }
    
    def display() {
        println "Bank: ${name}"
        println '===================='
        
        accounts.each { number, account -> account.display() }
    }
    
// ---------- properties ----------------------------------

    @Property name
    private accounts = [ : ]
}



	//  create a new Bank object
def bk = new Bank(name : 'Barclay')

	//  create some accounts
def ca1 = new CurrentAccount(number : 'AAA111', balance : 2000, overdraftLimit : 400)
def ca2 = new CurrentAccount(number : 'BBB222', balance : 3000, overdraftLimit : 800)
def da1 = new DepositAccount(number : 'CCC333', balance : 4000, interestRate : 4)

	//  add them to the bank
bk.openAccount(ca1)
bk.openAccount(ca2)
bk.openAccount(da1)

	//  now display everything
bk.display()
