interface EmployeeIF {
    def abstract getPayrollNumber()
    def abstract getMonthlySalary()
    def abstract display()
}

abstract class EmployeeAB implements EmployeeIF {

    def getPayrollNumber() {
        return payrollNumber
    }
    
    def getMonthlySalary() {
        return monthlySalary
    }
    
    def display() {
        println '  ' + this
    }
    
    String toString() {
        return "${name}: ${this.getPayrollNumber()} ${this.getMonthlySalary()}"
    }

// ---------- properties ----------------------------------

    @Property name
    @Property payrollNumber
    @Property monthlySalary
}

class Administrator extends EmployeeAB {

    String toString() {
        return 'Administrator: ' + super.toString() + " ${department}"
    }

// ---------- properties ----------------------------------

    @Property department
}

class Programmer extends EmployeeAB {
    
    def getMonthlySalary() {
        if(language == 'Groovy')
            return super.getMonthlySalary() + super.getMonthlySalary().intdiv(10)
        else
            return super.getMonthlySalary()
    }

    String toString() {
        return 'Programmer: ' + super.toString() + " ${language}"
    }

// ---------- properties ----------------------------------

    @Property language
}

class Consultant implements EmployeeIF {

    def getPayrollNumber() {
        return payrollNumber
    }
    
    def getMonthlySalary() {
        return 500
    }
    
    def display() {
        println '  ' + this
    }
    
    String toString() {
        return 'Consultant: ' + "${this.getPayrollNumber()} ${this.getMonthlySalary()}"
    }

// ---------- properties ----------------------------------

    @Property payrollNumber
}

class SoftwareHouse {

    def hire(employee) {
        employees[employee.payrollNumber] = employee
    }
    
    def displayStaff() {
        println "Software House: ${name}"
        
        employees.each { payrollNumber, employee ->
            employee.display()
        }
    }
    
// ---------- properties ----------------------------------

    @Property name
    @Property employees = [ : ]
}

def sh = new SoftwareHouse(name : 'Groovy R Us')

def ad = new Administrator(name : 'Jessie', payrollNumber : '1111', monthlySalary : 1000, department : 'Accounts')
def co = new Consultant(payrollNumber : '2222')
def pr1 = new Programmer(name : 'Ken', payrollNumber : '3333', monthlySalary : 2000, language : 'Groovy')
def pr2 = new Programmer(name : 'John', payrollNumber : '4444', monthlySalary : 2000, language : 'Java')

sh.hire(ad)
sh.hire(co)
sh.hire(pr1)
sh.hire(pr2)

sh.displayStaff()
