interface RoomIF {
    def abstract getRoomNumber()
    def abstract getOccupancy()
    def abstract display()
}

abstract class RoomAB implements RoomIF {
    
    def getString() {
        return "${roomNumber} ${occupancy}"
    }
    
    def display() {
        println '    ' + this
    }
    
// ---------- properties ----------------------------------

    @Property roomNumber
    @Property occupancy
}

class BedRoom extends RoomAB {
    
    String toString() {
        return 'BedRoom: ' + super.getString()
    }
}

class StudyRoom extends BedRoom {
    
    String toString() {
        return 'StudyRoom: ' + super.getString()
    }
}

class ConferenceRoom extends BedRoom {
    
    String toString() {
        return 'ConferenceRoom: ' + super.getString() + " ${name}"
    }
    
    def addStudyRoom(studyRoom) {
        studyRooms[studyRoom.getRoomNumber()] = studyRoom
    }
    
// ---------- properties ----------------------------------

    @Property name
    @Property studyRooms = [ : ]
}

class Floor {

    def addRoom(room) {
        rooms[room.getRoomNumber()] = room
    }
    
    def display() {
        println "  Floor: ${number}"
        
        rooms.each { roomNumber, room ->
            room.display()
        }
        
        println()
    }
    
// ---------- properties ----------------------------------

    @Property number
    @Property rooms = [ : ]
}

class Hotel {

    def addFloor(floor) {
        floors[floor.number] = floor
    }
    
    def display() {
        println "Hotel: ${name}"
        
        floors.each { floorNumber, floor ->
            floor.display()
        }
    }
    
    def addRoom(floorNumber, room) {
        def floor = floors[floorNumber]
        if(floor != null)
            floor.addRoom(room)
    }
    
// ---------- properties ----------------------------------

    @Property name
    @Property floors = [ : ]
}

def ho = new Hotel(name : 'Hilton')

def fl1 = new Floor(number : 1)
def fl2 = new Floor(number : 2)
def fl3 = new Floor(number : 3)

ho.addFloor(fl1)
ho.addFloor(fl2)
ho.addFloor(fl3)

def rm1 = new BedRoom(roomNumber : 101, occupancy : 4)
def rm2 = new BedRoom(roomNumber : 102, occupancy : 2)

def rm3 = new BedRoom(roomNumber : 201, occupancy : 4)
def rm4 = new StudyRoom(roomNumber : 202, occupancy : 8)
def rm5 = new ConferenceRoom(roomNumber : 203, occupancy : 4, name : 'Balmoral')

def rm6 = new BedRoom(roomNumber : 301, occupancy : 4)

ho.addRoom(1, rm1)
ho.addRoom(1, rm2)

ho.addRoom(2, rm3)
ho.addRoom(2, rm4)
ho.addRoom(2, rm5)

ho.addRoom(3, rm6)

ho.display()
