class Point {

    def moveBy(deltaX, deltaY) {
        x += deltaX
        y += deltaY
    }
    
// ---------- properties ----------------------------------

    @Property x
    @Property y
}

interface QuadrilateralIF {
    def abstract getArea()
    def abstract getPerimeter()
    def abstract moveBy(deltaX, deltaY)
}

class Rectangle implements QuadrilateralIF {
    def getArea() {
        return width * height
    }
    
    def getPerimeter() {
        return 2 * (width + height)
    }
    
    def moveBy(deltaX, deltaY) {
        upperLeft.moveBy(deltaX, deltaY)
    }

// ---------- properties ----------------------------------

    @Property upperLeft
    @Property width
    @Property height
}

class Square extends Rectangle {
}

def rect = new Rectangle(upperLeft : new Point(x : 0, y : 10), width : 10, height : 5)
rect.moveBy(2, 4)

println "rect: ${rect.getArea()}, ${rect.getPerimeter()}"		// output: 50, 30

def sq = new Square(upperLeft : new Point(x : 0, y : 10), width : 10, height : 10)

println "sq: ${sq.getArea()}, ${sq.getPerimeter()}"			// output: 100, 40
