import groovy.sql.*

def DB = 'jdbc:derby:currentdepositDB'
def USER = ''
def PASSWORD = ''
def DRIVER = 'org.apache.derby.jdbc.EmbeddedDriver'

	//  Connect to database
def sql = Sql.newInstance(DB, USER, PASSWORD, DRIVER)

	//  Iterate over the result set
println 'Current accounts'
println '  Number     Balance    Overdraft '
println '+----------+----------+----------+'
sql.eachRow('select * from currentaccounts') { cur ->
    def acc = sql.firstRow('select * from accounts where number = ?', [cur.number])
    printf('| %-8s | %-8d | %-8d |\n', [acc.number, acc.balance, cur.overdraftlimit])
}
println '+----------+----------+----------+'
println()

	//  Iterate over the result set
println 'Deposit accounts'
println '  Number     Number     Interest  '
println '+----------+----------+----------+'
sql.eachRow('select * from depositaccounts') { dep ->
    def acc = sql.firstRow('select * from accounts where number = ?', [dep.number])
    printf('| %-8s | %-8d | %-8d |\n', [acc.number, acc.balance, dep.interestrate])
}
println '+----------+----------+----------+'
