/**
 *  Some representative unit tests of the Groovy JDK extensions.
 *    They are intended to demonstrate that Groovy environment does
 *    not change the underlying JDK classes it does offer enhanced functionality.
 * 
 */

import groovy.util.GroovyTestCase

class GroovyJDKTests extends GroovyTestCase{

// Establish the fixture

    def obj
    def table
    def count
    
    void setUp() {
        obj = new Object();
        table = [11,12,13,14]
        count = 0
    }
    
    void tearDown() {
        obj = null
        table = null
        count = null
    }

// *******************************************************************
// *** Object tests
// *******************************************************************  
  
    // Show that we have an Object
    void testObjectClassName() {
        def className = obj.getClass().getName()
        assertTrue( className == 'java.lang.Object' )
    }
    
    // Show that we have a toString method
    void testObjecttoStringMethodName() {
        def methods = obj.getClass().getMethods()
        def methodNames = methods.collect{ element -> return element.getName() }
        assertTrue( methodNames.contains('toString') )
    }
    
    // Show that we have the correct number of public methods from JDK Object
    void testObjectMethodNumber() {
        def methods = obj.getClass().getMethods()
        assertTrue( methods.length == 9 )
    }
    
    // Show that we don't have an each method
    void testObjectEachMethodName() {
        def methods = obj.getClass().getMethods()
        def methodNames = methods.collect{ element -> return element.getName() }
        assertFalse( methodNames.contains("each") )
    }
    
    // Show that we can send the each message
    void testEachMethodCallForAnObject() {
        obj.each {element -> count++ }
        assertTrue( count == 1 )  
    }
    
// *******************************************************************
// *** List tests
// *******************************************************************  
        
    // Show that we have an ArrayList
    void testListClassName() {
        def className = table.getClass().getName()
        assertTrue( className == 'java.util.ArrayList' )
    }
    
    // Show that we have a size method
    void testListSizeMethodName() {
        def methods = table.getClass().getMethods()
        def methodNames = methods.collect{ element -> return element.getName() }
        assertTrue( methodNames.contains('size') )
    }

    // Show that we have the correct number of public methods from JDK ArrayList
    void testArrayListMethodNumber() {
        def methods = table.getClass().getMethods()
        assertTrue( methods.length == 35 )
    }

    // Show that we don't have an each method
    void testListEachMethodName() {
        def methods = obj.getClass().getMethods()
        def methodNames = methods.collect{ element -> return element.getName() }
        assertFalse( methodNames.contains('each') )
    }
    
    // Show that we can send the each message
    void testEachMethodCallForAList() {
        table.each {element -> count++ }
        assertTrue( count == 4 )   
    }

}