/**
 *  Some common list handling methods, combined to support operating
 *    on lists. These are then used to re-implement factorial.
 */

def head(list) {
    return (list.size() == 0) ? null : list[0]
}

def tail(list) {
    def size = list.size()
    return (size == 0) ? [] : list[1..<size]
}

def cons(item, list) {
    def copy = list
    copy.add(0, item)
    return copy
}



def upTo(m, n) {
    if(m > n)
        return []
    else
        return cons(m, upTo(m + 1, n))
}

def prod(list) {
    if(head(list) == null)
        return 1
    else
        return head(list) * prod(tail(list))
}

def factorial(n) {
    return prod(upTo(1, n))
}

println "factorial(5): ${factorial(5)}"
