/**
 *  Define a method that splits a list of lines into a list
 *    of the words in each line.
 */

def split(lines) {
    def words = []
    lines.each { line ->
        def wordsInLine = line.tokenize()
        words.addAll(wordsInLine)
    }
    return words
}

def doc = ["This is the first line", "This is the second line", "This is the third line"]
def words = split(doc).sort()

words.each { word ->
    println "${word}"
}

