/**
 *  Define a method that produces a list, in alphabetical order,
 *    of all the distinct words that appear in the text. Each
 *    word is accompanied with a list of line numbers on which
 *    the word appears.
 */

import java.util.*

def concordance(lines) {
    def lineNumber = 1
    def concord = [ : ]
    lines.each { line ->
        def wordsInLine = line.tokenize()
        wordsInLine.each { word ->
            if(concord[word] == null)
                concord[word] = [lineNumber]
            else
                concord[word] << lineNumber
        }
        lineNumber++
    }
    return concord
}

def printConcordance(concordance) {
    def words = concordance.keySet().sort()
    words.each { word ->
        print "${word} "
        concordance[word].each { lineNumber -> print "${lineNumber} "}
        println()
    }
}

def doc = ["This is the first line", "This is the second line", "This is the third line"]
def concord = concordance(doc)
printConcordance(concord)

